  '' MCP23017 Demo - REFER TO GUI
  OPTION BASE 0
  OPTION AUTORUN ON
  CONST ADDRESS = &H20  ''address could be &H20-&H27
  ''registers (with IOCON.BANK at POR value of 0)
  CONST IODIRA =(0)
  CONST GPPUA =(12)
  CONST GPIOA =(18)
  CONST OLATA =(20)
  CONST IODIRB =(1)
  CONST GPPUB =(13)
  CONST GPIOB =(19)
  CONST OLATB =(21)
  CONST OUT = 1
  CONST IN = 2
  CONST IN_PULLUP=3
  ''set static variables as global as static doesn't seem to work in some versions
  DIM INTEGER  DIRA=255                         ''keep value of direction registers between writes
  DIM INTEGER  DIRB=255                         ''default to &HFF (all input)
  DIM INTEGER  PUA=0                            ''keep value of pull-up registers between writes
  DIM INTEGER  PUB=0                            ''default to &H00 (all off)
  DIM INTEGER  LATA=0                            ''keep value of output registers between writes
  DIM INTEGER  LATB=0                            ''default to &H00 (all off)
  
  'for buttons
  Dim Integer key_coord(81, 5)
  Dim String key_caption(81)
  CONST C.BUTTON=RGB(WHITE)
  CONST C.OFF=RGB(RED)
  CONST C.ON=RGB(GREEN)
  ''STARTUP
  DIM INTEGER I       ''generic loop
  DIM INTEGER BUTTON  ''for GUI
  DIM INTEGER PINN    ''PIN to be commanded  
  I2C OPEN 400,100    ''MCP23017 can work up to 1.7MHz, 400 kHz is Micromite limit
  
  CLS
  FOR I = 0 to 15
    DrawButton I,0 ,I*20, 10, 19, 20,C.BUTTON, "I"
    DrawButton I+16,0 ,I*20, 40, 19, 20,C.BUTTON, "P"
    DrawButton I+32,0 ,I*20, 70, 19, 20,C.BUTTON, "1"
    DrawButton I+48,0 ,I*20, 100, 19, 20,C.BUTTON, "0"
    DrawButton I+65,0 ,I*20, 130, 19, 20,C.OFF, "-"
  NEXT I
  DrawButton 64,0 ,100, 170, 120, 40,C.BUTTON, "READ"   'put this button at 64 to keep the scanned buttons together
  DO_READ
  
  ''LOOP
  DO
    BUTTON=CheckButtonPress(0,64)
    if BUTTON >-1 THEN
      PAUSE 10
      CheckButtonRelease BUTTON
      PINN=BUTTON AND 15
      IF BUTTON >=0  AND BUTTON <=15 THEN MCP23017SETPIN(PINN,IN)        ''input
      IF BUTTON >=16 AND BUTTON <=31 THEN MCP23017SETPIN(PINN,IN_PULLUP) ''input with pullup
      IF BUTTON >=32 AND BUTTON <=63 THEN MCP23017SETPIN(PINN,OUT)       ''output
      IF BUTTON >=32 AND BUTTON <=47 THEN MCP23017WRITEPIN(PINN,1)       ''High
      IF BUTTON >=48 AND BUTTON <=63 THEN MCP23017WRITEPIN(PINN,0)       ''LOW
      PAUSE 10    ''allow new state to settle
      DO_READ     ''on any button press
      PRINT BUTTON
    ENDIF
  LOOP
END
  
SUB DO_READ
  FOR I = 0 to 15
    IF MCP23017READPIN(I) >0 THEN
      DrawButton I+65,0 ,I*20, 130, 19, 20,C.ON, "+"
    ELSE
      DrawButton I+65,0 ,I*20, 130, 19, 20,C.OFF, "-"
    ENDIF
  NEXT I
END SUB
  
SUB MCP23017SETPIN(P AS INTEGER, D AS INTEGER)    ''set pin mode (like SETPIN statement)
  PRINT "SETPIN:";P;" to ";D
  LOCAL INTEGER MASK
  MASK = 1 << (P AND 7)
  IF (P >= 0) AND (P<=7) THEN                   ''on bank A
    IF D = OUT THEN
      DIRA = DIRA AND (255-MASK)
      PUA = PUA AND (255-MASK)
    ENDIF
    IF D = IN THEN
      DIRA = DIRA OR MASK
      PUA = PUA AND (255-MASK)
    ENDIF
    IF D = IN_PULLUP THEN
      DIRA = DIRA OR MASK
      PUA = PUA OR MASK
    ENDIF
    I2C WRITE ADDRESS,0,2,IODIRA,DIRA
    I2C WRITE ADDRESS,0,2,GPPUA,PUA
  ENDIF
  IF (P >= 8) AND (P<=15) THEN                   ''on bank B
    IF D = OUT THEN
      DIRB = DIRB AND (255-MASK)
      PUB = PUB AND (255-MASK)
    ENDIF
    IF D = IN THEN
      DIRB = DIRB OR MASK
      PUB = PUB AND (255-MASK)
    ENDIF
    IF D = IN_PULLUP THEN
      DIRB = DIRB OR MASK
      PUB = PUB OR MASK
    ENDIF
    I2C WRITE ADDRESS,0,2,IODIRB,DIRB
    I2C WRITE ADDRESS,0,2,GPPUB,PUB
  ENDIF
END SUB
  
FUNCTION MCP23017READPIN(P AS INTEGER)            ''read pin state (like PIN function)
  LOCAL INTEGER D
  LOCAL INTEGER MASK
  MASK = 1 << (P AND 7)
  MCP23017READPIN=0
  IF (P >= 0) AND (P<=7) THEN                   ''on bank A
    I2C WRITE ADDRESS,1,1,GPIOA
    I2C READ ADDRESS,0,1,D
    if (D and MASK) >0 THEN MCP23017READPIN=1
  ENDIF
  IF (P >= 8) AND (P<=15) THEN                  ''on bank B
    I2C WRITE ADDRESS,1,1,GPIOB
    I2C READ ADDRESS,0,1,D
    if (D and MASK) >0 THEN MCP23017READPIN=1
  ENDIF
  PRINT "READ:";P;" is ";MCP23017READPIN
END FUNCTION
  
SUB MCP23017WRITEPIN(P AS INTEGER, D AS INTEGER)  ''set pin state (like PIN()= statement)
  PRINT "WRITEPIN:";P;" to ";D
  LOCAL INTEGER MASK
  MASK = 1 << (P AND 7)
  IF (P >= 0) AND (P<=7) THEN                   ''on bank A
    IF D >0 THEN
      LATA = LATA OR MASK
    ELSE
      LATA = LATA AND (255-MASK)
    ENDIF
    I2C WRITE ADDRESS,0,2,OLATA,LATA
  ENDIF
  IF (P >= 8) AND (P<=15) THEN                   ''on bank B
    IF D >0 THEN
      LATB = LATB OR MASK
    ELSE
      LATB = LATB AND (255-MASK)
    ENDIF
    I2C WRITE ADDRESS,0,2,OLATB,LATB
  ENDIF
END SUB
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw buttons and get button presses
  '
  ' The subrouting DrawButton will draw a button (normally used when drawing
  ' the screen for input).
  '
  ' The function CheckButtonPress() will check if a button has been touched.
  ' If it has it will set it to selected (reverse video) and return with the
  ' button's number.
  '
  ' The subroutine CheckButtonRelease will wait for the touch to be released
  ' and will then draw the button as normal.
  '
  ' These routines use the global arrays key_coord() and key_caption() to
  ' track the coordinates and size of each button and save its caption.
  '
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  ' check if a button has been touch and animate the button's image
  ' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yellowt, n
  
  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function
  
  
  ' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub
  
  ' draw a button
Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
  Local Integer bc, fc
  
  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s
  EndIf
  
  If mode > 1 Then
    bc = key_coord(n,4) : fc = 0    ' draw in reverse video if it is being touched
  Else
    bc = 0 : fc = key_coord(n,4)    ' a normal (untouched) button
  EndIf
  
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, , , fc, bc
End Sub

